IF EXISTS ( SELECT * 
            FROM   sysobjects 
            WHERE  id = object_id(N'dbo.CF_Turno_Asistencia_Validar') 
                   and type = 'FN')
BEGIN
    DROP FUNCTION dbo.CF_Turno_Asistencia_Validar
END
GO

CREATE FUNCTION [dbo].[CF_Turno_Asistencia_Validar](@pId_Cliente INT, @pId_Turno BIGINT, @pId_Sector INT)
RETURNS VARCHAR(5000)
AS
BEGIN

DECLARE @Respuesta				VARCHAR(5000) 
DECLARE @Fecha					DATETIME
DECLARE @Id_Recurso				INT 
DECLARE @Id_Sector				SMALLINT
DECLARE @Id_Sector_Deseado		SMALLINT
DECLARE @Id_Sede_deseada        SMALLINT
DECLARE @Flag_Asistencia		TINYINT
DECLARE @Horas_Asistencia		INT

DECLARE @Socio					VARCHAR(500)
DECLARE @Entrada				INT 
DECLARE @Descripcion_Sede		VARCHAR(50)
--===========================================================================================
SELECT	@Id_Recurso = ISNULL(Id_Recurso, 0),
		@Fecha		= Fecha
FROM CRM_Turnos 
WHERE 
Id_Turno = @pId_Turno

--===========================================================================================

SELECT @Id_Sector_Deseado = ISNULL(Id_Sector, 0),
	   @Flag_Asistencia   = ISNULL(Flag_Asistencia,0),
	   @Horas_Asistencia  = ISNULL(Horas_Asistencia,0)
FROM Empresas_Sedes_Sec_Recursos
WHERE
Id_Recurso = @Id_Recurso

--===========================================================================================

SELECT @Id_Sede_deseada   = ISNULL(Id_Sede, 0),
	   @Descripcion_Sede  = Descripcion
FROM Empresas_Sedes_Sectores
WHERE
Id_sector = @Id_Sector_Deseado

--===========================================================================================

SELECT @Socio = Razon_Social FROM Clientes WHERE Id_Cliente = @pId_Cliente

--===========================================================================================

IF (@Flag_Asistencia = 1 AND @Horas_Asistencia > 0)
BEGIN

	SET @Entrada = (SELECT COUNT(*) FROM CD_ES
					WHERE FECHA BETWEEN (SELECT DATEADD(HOUR,-@Horas_Asistencia,GETDATE()))
					and GETDATE()
					AND Tipo='E'
					AND Id_Cliente=@pId_Cliente)

		IF @Entrada = 0
		BEGIN
			SET @Respuesta = @Socio 
			RETURN @Respuesta
		END	

END
RETURN ISNULL(@Respuesta, '')
END